<?php

namespace Drupal\inside\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\Plugin\Field\FieldWidget\StringTextfieldWidget;
use Drupal\Core\Form\FormStateInterface;

/**
 * Plugin implementation of the 'inside_phone_field_widget' widget.
 *
 * @FieldWidget(
 *   id = "inside_phone_field_widget",
 *   module = "inside",
 *   label = @Translation("Inside phone field widget"),
 *   field_types = {
 *     "string"
 *   }
 * )
 */
class InsidePhoneFieldWidget extends StringTextfieldWidget
{
    public static function defaultSettings()
    {
        return [
                'short_number_length' => 0,
            ] + parent::defaultSettings();
    }

    public function settingsSummary() {
        $summary = [];

        $summary[] = t('Textfield size: @size', ['@size' => $this->getSetting('size')]);
        $placeholder = $this->getSetting('placeholder');
        if (!empty($placeholder)) {
            $summary[] = t('Placeholder: @placeholder', ['@placeholder' => $placeholder]);
        }

        return parent::settingsSummary() + [
            t('Longueur du numéro court: @short_number_length',['@short_number_length' =>  $this->getSetting('short_number_length')])
            ];
    }

    public function formElement(
        FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state
    ) {
        $element['value'] = $element + [
                '#type'                => 'textfield',
                '#default_value'       => isset($items[$delta]->value) ? $items[$delta]->value : null,
                '#size'                => $this->getSetting('size'),
                '#placeholder'         => $this->getSetting('placeholder'),
                '#short_number_length' => $this->getSetting('short_number_length'),
                '#maxlength'           => $this->getFieldSetting('max_length'),
                '#attributes'          => ['class' => ['js-text-full', 'text-full']],
            ];

        return $element;
    }

    public function settingsForm(array $form, FormStateInterface $form_state)
    {
        return parent::settingsForm($form, $form_state) + [
                'short_number_length' => [
                    '#type'          => 'number',
                    '#title'         => t('Longueur du numéro court'),
                    '#default_value' => $this->getSetting('short_number_length'),
                    '#description'   => t(
                        'Longueur du numéro court, par défaut 0. Si la longueur est égal à 0, les numéros courts ne sont pas supportés.'
                    ),
                ],
            ];
    }
}
