<?php

namespace Drupal\inside\Plugin\Field\FieldWidget;

use Drupal\Core\Field\Plugin\Field\FieldWidget\StringTextfieldWidget;
use Drupal\Core\Form\FormStateInterface;
use Egulias\EmailValidator\EmailValidator;
use Egulias\EmailValidator\Validation\DNSCheckValidation;
use Egulias\EmailValidator\Validation\MultipleValidationWithAnd;
use Egulias\EmailValidator\Validation\NoRFCWarningsValidation;
use Egulias\EmailValidator\Validation\RFCValidation;
use Egulias\EmailValidator\Validation\SpoofCheckValidation;
use Illuminate\Support\Str;

/**
 * Plugin implementation of the 'inside_icon_picker_field_widget' widget.
 *
 * @FieldWidget(
 *   id = "inside_icon_picker_field_widget",
 *   module = "inside",
 *   label = @Translation("Inside Icon picker field widget"),
 *   field_types = {
 *     "string"
 *   }
 * )
 */
class InsideIconPickerFieldWidget extends StringTextfieldWidget
{
    public static function defaultSettings()
    {
        return [
                'size'        => 50,
                'placeholder' => '',
            ] + parent::defaultSettings();
    }

    public function settingsForm(array $form, FormStateInterface $form_state)
    {
        return [];
    }
}
