<?php

namespace Drupal\inside\Plugin\Field\FieldWidget;

use Drupal\Core\Field\Plugin\Field\FieldWidget\StringTextfieldWidget;
use Drupal\Core\Form\FormStateInterface;
use Egulias\EmailValidator\EmailValidator;
use Egulias\EmailValidator\Validation\DNSCheckValidation;
use Egulias\EmailValidator\Validation\MultipleValidationWithAnd;
use Egulias\EmailValidator\Validation\NoRFCWarningsValidation;
use Egulias\EmailValidator\Validation\RFCValidation;
use Egulias\EmailValidator\Validation\SpoofCheckValidation;
use Illuminate\Support\Str;

/**
 * Plugin implementation of the 'inside_color_picker_field_widget' widget.
 *
 * @FieldWidget(
 *   id = "inside_color_picker_field_widget",
 *   module = "inside",
 *   label = @Translation("Inside Color picker field widget"),
 *   field_types = {
 *     "string"
 *   }
 * )
 */
class InsideColorPickerFieldWidget extends StringTextfieldWidget
{
    public static function defaultSettings()
    {
        return [
                'size'        => 50,
                'placeholder' => '#ffffff',
            ] + parent::defaultSettings();
    }

    public function settingsForm(array $form, FormStateInterface $form_state)
    {
        return [];
    }

    public function massageFormValues(array $values, array $form, FormStateInterface $form_state)
    {
        foreach ($values as &$item) {
            if (!preg_match('/^(\#[\da-f]{3}|\#[\da-f]{6}|rgba\(((\d{1,2}|1\d\d|2([0-4]\d|5[0-5]))\s*,\s*){2}((\d{1,2}|1\d\d|2([0-4]\d|5[0-5]))\s*)(,\s*(0\.\d+|1))\)|hsla\(\s*((\d{1,2}|[1-2]\d{2}|3([0-5]\d|60)))\s*,\s*((\d{1,2}|100)\s*%)\s*,\s*((\d{1,2}|100)\s*%)(,\s*(0\.\d+|1))\)|rgb\(((\d{1,2}|1\d\d|2([0-4]\d|5[0-5]))\s*,\s*){2}((\d{1,2}|1\d\d|2([0-4]\d|5[0-5]))\s*)|hsl\(\s*((\d{1,2}|[1-2]\d{2}|3([0-5]\d|60)))\s*,\s*((\d{1,2}|100)\s*%)\s*,\s*((\d{1,2}|100)\s*%)\))$/i', $item['value'])) {
                $item['value'] = null;
            }
        }

        return $values;
    }
}
