<?php

namespace Inside\Host\Normalizer;

use Drupal\Core\Field\FieldItemList;
use Drupal\Core\Field\FieldItemListInterface;
use Log;
use Symfony\Component\Serializer\Exception\InvalidArgumentException;
use Symfony\Component\Serializer\Exception\UnexpectedValueException;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Serializer;

/**
 * Field Normalizer
 *
 * @category Class
 * @package  Inside\Host\Normalizer\FieldNormalizer
 * @author   Maecia <technique@maecia.com>
 * @author   Nicolas Deniaud <contact@feldoe.net>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class FieldNormalizer extends ListNormalizer implements DenormalizerInterface
{
    /**
     * {@inheritdoc}
     */
    protected $supportedInterfaceOrClass = FieldItemListInterface::class;

    /**
     * {@inheritdoc}
     */
    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (!isset($context['target_instance'])) {
            throw new \InvalidArgumentException(
                '$context[\'target_instance\'] must be set to denormalize with the FieldNormalizer'
            );
        }

        if ($context['target_instance']->getParent() == null) {
            throw new \InvalidArgumentException(
                'The field passed in via $context[\'target_instance\'] must have a parent set.'
            );
        }

        $items = $context['target_instance'];
        $class = $items->getItemDefinition()->getClass();

        if (is_string($data)) {
            $data = [0 => ['value' => $data]];
        }

        if (!is_array($data)) {
            throw new UnexpectedValueException(
                sprintf('Field values for "%s" must use an array structure', $items->getName())
            );
        }

        foreach ($data as $item) {
            $context['target_instance'] = $items->appendItem();
            $this->serializer->denormalize($item, $class, $format, $context);
        }

        return $items;
    }
}
