<?php

namespace Inside\Host\Normalizer\Field;

use Inside\Host\Normalizer\FieldItemNormalizer;
use Log;

/**
 * Language Normalizer
 *
 * @category Class
 * @package  Inside\Host\Normalizer\Field\LanguageNormalizer
 * @author   Maecia <technique@maecia.com>
 * @author   Nicolas Deniaud <contact@feldoe.net>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class LanguageNormalizer extends FieldItemNormalizer
{
    /**
     * {@inheritDoc}
     */
    protected $supportedInterfaceOrClass = [
        \Drupal\Core\Field\Plugin\Field\FieldType\LanguageItem::class,
    ];

    /**
     * {@inheritdoc}
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = $object->getValue();

        if (isset($data['value'])) {
            return ($data['value'] === 'und') ? '' : $data['value'];
        }

        return $data === 'und' ? '' : $data;
    }

    /**
     * {@inheritdoc}
     */
    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if ($data === '') {
            $data = 'und';
        }
        return parent::denormalize($data, $class, $format, $context);
    }
}
