<?php

namespace Inside\Host\Normalizer\Field;

use Drupal\serialization\Normalizer\EntityReferenceFieldItemNormalizer;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

/**
 * Entity Reference Normalizer
 *
 * @category Class
 * @package  Inside\Host\Normalizer\Field\EntityReferenceNormalizer
 * @author   Maecia <technique@maecia.com>
 * @author   Nicolas Deniaud <contact@feldoe.net>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class EntityReferenceNormalizer extends EntityReferenceFieldItemNormalizer
{
    /**
     * {@inheritdoc}
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $field       = $object->getFieldDefinition();
        $cardinality = $field->getFieldStorageDefinition()->getCardinality();
        $values      = parent::normalize($object, $format, $context);

        $this->normalizeRootReferenceValue($values, $object);

        if ($entity = $object->get('entity')->getValue()) {
            /**
             * If reference is user, we don't want langcode, user can have its pref
             * to any language and is not related to the parent object langcode
             */
            if ($entity instanceof \Drupal\user\Entity\User) {
                $context['langcode'] = $entity->language()->getId();
            }

            return get_lumen_entity_uuid($entity, $context['langcode']);
        }

        return [];
    }
}
