<?php
namespace Inside\Host\Normalizer\Entity;

use Illuminate\Support\Facades\Log;
use Inside\Host\Normalizer\Entity\BaseEntityNormalizer;

/**
 * Menu Link Normalizer
 *
 * @category Class
 * @package  Inside\Host\Normalizer\Entity\MenuLinkNormalizer
 * @author   Maecia <technique@maecia.com>
 * @author   Nicolas Deniaud <contact@feldoe.net>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class MenuLinkNormalizer extends BaseEntityNormalizer
{

    /**
     * {@inheritdoc}
     */
    protected $supportedInterfaceOrClass = [
        \Drupal\menu_link_content\MenuLinkContentInterface::class,
        \Drupal\menu_item_extras\Entity\MenuItemExtrasMenuLinkContent::class,
    ];

    /**
     * {@inheritdoc}
     */
    protected $removableFields = [
        'id',
        'bundle',
        'description',
        'menu_name',
        'rediscover',
        'expanded',
        'external',
        'changed',
        'view_mode',
        'default_langcode',
        'content_translation_source',
        'content_translation_outdated',
        'content_translation_uid',
        'content_translation_status',
        'content_translation_created',
    ];

    /**
     * {@inheritDoc}
     */
    protected $swappableNames = [
        'parent'  => 'pid',
        'uuid'    => 'uuid_host',
        'enabled' => 'status',
    ];

    /**
     * {@inheritDoc}
     */
    public function normalize($entity, $format = null, array $context = [])
    {
        $context['langcode'] = $entity->language()->getId();
        $attributes = parent::normalize($entity, $format, $context);

        $attributes =  $this->formatDatasToNormalization($entity, $attributes);

        $attributes['bundle'] = $entity->bundle();
        $attributes['type']   = $entity->getEntityTypeId();
        $attributes['uuid']   = get_lumen_entity_uuid($entity);

        return $attributes;
    }

    /**
     * {@inheritDoc}
     */
    public function denormalize($data, $class, $format = null, array $context = [])
    {
        $values = [];
        $data   = $this->prepareLangs($data, $values, 'default_langcode', 'langcode');

        $values['bundle']  = $data['bundle'];

        $data['menu_name'] = str_replace('_menus', '', $values['bundle']);

        unset($data['bundle']);

        try {
            $entity = $this->createEntity($values, $data, $context, 'menu_link_content', 'id');
            $result = $this->formatDatasToDenormalization($data, $data['type'], $data['menu_name']);

            // Remove unwanted fields for menu
            unset($result['type']);
            unset($result['author']);
            unset($result['created_at']);

            $this->denormalizeFieldData($result, $entity, $format, $context);
        } catch (\Exception $e) {
            Log::error('[MenuLinkNormalizer] Menu Link denormalization failed [' . $e->getMessage() . ']');
            Log::debug('[MenuLinkNormalizer] Menu Link denormalization failed trace [' . $e->getTraceAsString() . ']');
        }

        return $entity;
    }
}
