<?php
namespace Inside\Host\Normalizer\Entity;

use Drupal\Core\Entity\FieldableEntityInterface;

trait FieldableEntityNormalizer
{
    protected function denormalizeFieldData(array $data, FieldableEntityInterface $entity, $format, array $context)
    {
        foreach ($data as $field_name => $field_data) {
            $field_item_list = $entity->get($field_name);

            // Remove any values that were set as a part of entity creation (e.g
            // uuid). If the incoming field data is set to an empty array, this will
            // also have the effect of emptying the field in REST module.
            $field_item_list->setValue([]);
            $field_item_list_class = get_class($field_item_list);

            /**
             * Inside fix:
             * If $field_data is a boolean and value is false, it won't never
             * been saved, so check if $field_data is set instead( relevant ? )
             *
             */
            if (isset($field_data)) {
                // The field instance must be passed in the context so that the field
                // denormalizer can update field values for the parent entity.
                $context['target_instance'] = $field_item_list;
                $this->serializer->denormalize($field_data, $field_item_list_class, $format, $context);
            }
        }
    }
}
