<?php

namespace Inside\Host\Helpers\Adapter\Form;

use Illuminate\Support\Str;
use Inside\Host\Helpers\Adapter\Form\BaseForm;

/**
 * Flatten formDisplay from Drupal 8
 *
 * @category Class
 * @package  Inside\Host\Adapter\Form\ParagraphForm
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class ParagraphForm extends BaseForm
{
    /**
     * {@inheritDoc}
     */
    protected const REMOVABLE_FIELD = [
        'id',
        'uuid',
        'revision_id',
        'uid',
        'revision_uid',
        'parent_field_name',
        'behavior_settings',
        'default_langcode',
        'revision_default',
        'revision_translation_affected',
        'content_translation_source',
        'content_translation_outdated',
        'content_translation_changed',
        'content_translation_uid',
    ];

    /**
     * {@inheritDoc}
     */
    protected const FIELD_NAME = [];

    /**
     * {@inheritDoc}
     */
    protected function getModel(): string
    {
        return 'Inside\Content\Models\Sections\\' . Str::studly($this->bundle);
    }
}
