<?php

namespace Inside\Host\Helpers\Adapter\Form;

use Inside\Host\Helpers\Adapter\Form\BaseForm;

/**
 * Flatten formDisplay from Drupal 8
 *
 * @category Class
 * @package  Inside\Host\Adapter\Form\CommentForm
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class CommentForm extends BaseForm
{
    /**
     * {@inheritDoc}
     */
    protected const REMOVABLE_FIELD = [
        'subject',
        'cid',
        'uuid',
        'comment_type',
        'pid',
        'entity_id',
        'name',
        'mail',
        'homepage',
        'hostname',
        'thread',
        'entity_type',
        'field_name',
        'default_langcode',
    ];

    /**
     * {@inheritDoc}
     */
    protected const FIELD_NAME = [
        'comment_body' => 'body',
    ];

    /**
     * {@inheritDoc}
     */
    protected function handleCustomFields(&$oldFields): void
    {
        $model   = $this->getModel();

        $customs = [
            ['name'  => 'created_at', 'type'  => 'datetime', 'title' => 'Authored on', 'widget' => 'datetime', 'default' => null],
            ['name'  => 'status',     'type'  => 'checkbox', 'title' => 'Status',      'widget' => 'onoff',    'default' => 1],
        ];

        foreach ($customs as $custom) {
            $title       = [];
            $description = [];

            foreach ($this->languages as $language) {
                $title[$language]       =  (string)t($custom['title'], [], ['langcode' => $language]);
                $description[$language] = '';
            }

            $options = [
                'title'        => $title,
                'description'  => $description,
                'cardinality'  => 1,
                'translatable' => false,
                'required'     => true,
                'default'      => $custom['default'],
                'weight'       => $this->drupalFormFields['author']['weight'],
                'widget'       => $custom['widget'],
                'group'        => [],
            ];

            $this->attachGroup('author', $options);

            $data = [
                'model'     => $model,
                'name'      => $custom['name'],
                'type'      => $custom['type'],
                'displayed' => true,
                'options'   => $options,
            ];

            $this->createOrUpdateField($data);
            if (($key = $oldFields->search($custom['name'])) !== false) {
                $oldFields->forget($key);
            }
        }
    }

    /**
     * {@inheritDoc}
     */
    protected function handleAttributeFields(string $name, $field = null, bool $isHidden = false): void
    {
        $model       = $this->getModel();
        $saveField   = false;
        $title       = '';
        $type        = 'text';
        $weight      = 0;

        if (is_array($field)) {
            $weight = $field['weight'];
        }

        $options = [
            'cardinality'  => 1,
            'translatable' => false,
            'required'     => true,
            'weight'       => $weight,
            'default'      => null,
            'widget'       => '',
            'group'        => [],
            'searchable'   => false,
        ];

        switch ($name) {
            case 'author':
                $saveField         = true;
                $titleText         = 'Author';
                $type              = 'reference';
                $options['widget'] = 'autocomplete';
                $options['target'] = ['users'];
                break;
            case 'langcode':
                $avalaibleLanguages = \Drupal::languageManager()->getLanguages();

                $saveField                 = true;
                $titleText                 = 'Language';
                $type                      = 'select';
                $options['widget']         = 'select';
                $options['default']        = \Drupal::languageManager()->getDefaultLanguage()->getId();
                $options['allowed_values'] = [];

                foreach ($avalaibleLanguages as $avalaibleLanguage) {
                    $options['allowed_values'][$avalaibleLanguage->getId()] = $avalaibleLanguage->getName();
                }
                break;
        }

        if ($saveField) {
            $title       = [];
            $description = [];

            foreach ($this->languages as $language) {
                $title[$language]       =  (string)t($titleText, [], ['langcode' => $language]);
                $description[$language] = '';
            }

            $options['title']       = $title;
            $options['description'] = $description;

            $this->attachGroup($name, $options);

            $data = [
                'model'     => $model,
                'name'      => $name,
                'type'      => $type,
                'options'   => $options,
                'displayed' => !$isHidden,
            ];

            $this->createOrUpdateField($data);
        }
    }
}
