<?php

namespace Inside\Host\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\user\Entity\User;
use Inside\Host\Commands\InsideDrushCommands;

/**
 * Defines a form that allows privileged users to run Drush commands.
 */
class InsideDrushForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'inside_drush_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $commands = get_class_methods('\Inside\Host\Commands\InsideDrushCommands');
    foreach ($commands as $key) {
      $commands[$key] = $key;
    }

    $form['command'] = [
      '#title'         => $this->t('Commands'),
      '#type'          => 'select',
      '#options'       => $commands,
      '#default_value' => 'init_fields',
    ];

    $form['actions'] = [
      '#type'  => 'actions',
      'submit' => [
        '#type'  => 'submit',
        '#value' => $this->t('Run'),
      ],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $drush   = new InsideDrushCommands();
    $command = $form_state->getValue('command');

    if (method_exists($drush, $command)) {
      $drush->$command();
    }
  }

}
