<?php

namespace Inside\Host\Exodus\Services;

use Drupal;
use Drupal\Core\Language\Language;
use Drupal\node\Entity\NodeType;
use Exception;
use Illuminate\Support\Collection;
use Inside\Host\Services\DrupalService;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * We do not use laravel singleton registry because tinker and laravel do not understand annotations binding through phpdocs of drupal class.
 * When we try to use a drupal service multiple times in the same tinker session, we get this error:
 * "The class "Annotation" is not annotated with @Annotation. Are you sure this class can be used as annotation?"
 *
 * That why this service implement it's own singleton pattern.
 *
 * @mixin ContainerInterface
 */
class DrupalContainer
{
    private static self $instance;

    private ContainerInterface $container;

    private Collection $source;

    /**
     * @throws Exception
     */
    public function __construct()
    {
        new DrupalService();

        $this->container = Drupal::getContainer();

        $languages = collect($this->container->get('language_manager')->getLanguages());

        $nodeTypes = collect($this->container->get('entity_type.manager')->getStorage('node_type')->loadMultiple())->map(fn (NodeType $nodeType) => $nodeType->toArray());

        $this->source = $nodeTypes->map(function (array $nodeType) use ($languages) {
            $translations = collect();
            $type = $nodeType['type'];

            $languages->each(fn (Language $language) => $translations->put(
                key: $language->getId(),
                value: Drupal::languageManager()->getLanguageConfigOverride($language->getId(), "node.type.$type")->get('name')
            ));

            $nodeType['translations'] = $translations->toArray();

            return $nodeType;
        });
    }

    public function __call($method, $parameters)
    {
        return $this->container->{$method}(...$parameters);
    }

    public function source(): Collection
    {
        return $this->source;
    }
}
