<?php

namespace Inside\Host\EventSubscriber;

use Drupal\Core\Routing\RouteBuildEvent;
use Drupal\Core\Routing\RoutingEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Alter drupal routes
 *
 * @category Class
 * @package  Inside\Host\EventSubscriber\RouteEventSubscriber
 * @author   Maecia <technique@maecia.com>
 * @copyright 2019 Maecia
 * @link     http://www.maecia.com/
 */
class RouteEventSubscriber implements EventSubscriberInterface
{
    /**
     * Routes to alter
     */
    const ROUTES_IDS = [
        'entity.comment.edit_form',
        'comment.node_redirect',
        'comment.new_comments_node_links',
        'comment.reply',
        'entity.comment.delete_multiple_form',
        'comment.multiple_delete_confirm',
        'entity.comment.delete_form',
        'entity.comment.canonical',
        'comment.approve',
        'comment.admin_approval',
        'comment.admin',
    ];

    /**
     * {@inheritdoc}
     */
    public static function getSubscribedEvents()
    {
        $events[RoutingEvents::ALTER] = 'alter';
        return $events;
    }

    /**
     * Alters existing routes.
     *
     * @param \Drupal\Core\Routing\RouteBuildEvent $event
     */
    public function alter(RouteBuildEvent $event)
    {
        $collection = $event->getRouteCollection();

        foreach (static::ROUTES_IDS as $id) {
            if ($route = $collection->get($id)) {
                $route->setOption('_admin_route', true);
            }
        }
    }
}
