<?php

namespace Inside\Host\EventSubscriber\EntityType;

use Schema;
use Illuminate\Database\Schema\Blueprint;
use Inside\Host\Event\EntityType\NodeType\NodeTypeInsertEvent;
use Inside\Host\Event\EntityType\NodeType\NodeTypeUpdateEvent;
use Inside\Host\Event\EntityType\NodeType\NodeTypeDeleteEvent;
use Inside\Host\EventSubscriber\EntityType\BaseEntityTypeEventSubscriber;
use Log;

/**
 * Define node type events triggered in Drupal 8
 *
 * @category Class
 * @package  Inside\Host\EventSubscriber\NodeType\NodeTypeEventSubscriber
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class NodeTypeEventSubscriber extends BaseEntityTypeEventSubscriber
{
    /**
     * NodeTypeEventSubscriber constructor.
     */
    public function __construct()
    {
        parent::__construct();

        $this->bundleKey = 'type';
    }

    /**
     * {@inheritDoc}
     */
    const RESERVED_NAME = [
        'menus',
        'users'
    ];

    /**
     * {@inheritdoc}
     */
    public static function getSubscribedEvents()
    {
        $events[NodeTypeInsertEvent::INSERT][] = ['insert'];
        $events[NodeTypeUpdateEvent::UPDATE][] = ['update'];
        $events[NodeTypeDeleteEvent::DELETE][] = ['delete'];

        return $events;
    }

    /**
     * {@inheritDoc}
     */
    protected function createTable(): void
    {
        Schema::create($this->table, function (Blueprint $table) {
            $table->uuid('uuid')->collate('utf8');
            $table->uuid('uuid_host')->collate('utf8');
            $table->tinyInteger('status')->default(0);
            $table->char('langcode', 2)->nullable();
            $table->string('title', 255);
            $table->uuid('author')->collate('utf8')->nullable();
            $table->uuid('author_id')->comment('Author uuid');
            $table->uuid('update_author')->collate('utf8')->nullable();
            $table->uuid('pid')->collate('utf8')->nullable();
            $table->timestamps();
            $table->timestamp('published_at');

            $table->primary('uuid');
            $table->index('status');
            $table->index('langcode');
            $table->index('uuid_host');
            $table->index('pid');
            $table->index(['uuid', 'langcode']);

            $table->foreign('author')->references('uuid')->on('inside_content_users');
            $table->foreign('author_id')->references('uuid')->on('inside_users');
            $table->foreign('update_author')->references('uuid')->on('inside_content_users');
        });
    }
}
