<?php

namespace Inside\Host\EventSubscriber\EntityType;

use Schema;
use Illuminate\Database\Schema\Blueprint;
use Inside\Host\Event\EntityType\CommentType\CommentTypeInsertEvent;
use Inside\Host\Event\EntityType\CommentType\CommentTypeUpdateEvent;
use Inside\Host\Event\EntityType\CommentType\CommentTypeDeleteEvent;
use Inside\Host\EventSubscriber\EntityType\BaseEntityTypeEventSubscriber;

/**
 * Define comment type events triggered in Drupal 8
 *
 * @category Class
 * @package  Inside\Host\EventSubscriber\CommentType\CommentTypeEventSubscriber
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
class CommentTypeEventSubscriber extends BaseEntityTypeEventSubscriber
{

    /**
     * {@inheritDoc}
     */
    const RESERVED_NAME = [
        'menus',
        'users'
    ];

    /**
     * {@inheritdoc}
     */
    public static function getSubscribedEvents()
    {
        $events[CommentTypeInsertEvent::INSERT][] = ['insert'];
        $events[CommentTypeUpdateEvent::UPDATE][] = ['update'];
        $events[CommentTypeDeleteEvent::DELETE][] = ['delete'];

        return $events;
    }

    /**
     * {@inheritDoc}
     */
    protected function createTable(): void
    {
        Schema::create($this->table, function (Blueprint $table) {
            $table->uuid('uuid')->collate('utf8');
            $table->uuid('uuid_host')->collate('utf8');
            $table->tinyInteger('status')->default(0);
            $table->char('langcode', 2)->nullable();
            $table->uuid('author')->collate('utf8')->nullable();
            $table->uuid('pid')->collate('utf8')->nullable();
            $table->timestamps();

            $table->primary('uuid');
            $table->index('status');
            $table->index('langcode');
            $table->index('pid');
            $table->index(['uuid', 'langcode']);

            $table->foreign('author')->references('uuid')->on('inside_content_users');
        });
    }
}
