<?php
declare(strict_types=1);

namespace Inside\Host\EventSubscriber\Entity;

use Inside\Host\Event\Entity\MenuLink\MenuLinkInsertEvent;
use Inside\Host\Event\Entity\MenuLink\MenuLinkUpdateEvent;
use Inside\Host\Event\Entity\MenuLink\MenuLinkDeleteEvent;

/**
 * Define menu link events triggered in Drupal 8
 *
 * @category Class
 * @package  Inside\Host\EventSubscriber\MenuLink\MenuLinkEventSubscriber
 * @author   Maecia <technique@maecia.com>
 * @copyright 2018 Maecia
 * @link     http://www.maecia.com/
 */
final class MenuLinkEventSubscriber extends BaseEntityEventSubscriber
{
    protected const ENTITY_TYPE = 'menu_link_content';

    public static function getSubscribedEvents(): array
    {
        $events[MenuLinkInsertEvent::INSERT][] = ['process'];
        $events[MenuLinkUpdateEvent::UPDATE][] = ['process'];
        $events[MenuLinkDeleteEvent::DELETE][] = ['process'];

        return $events;
    }
}
