<?php
declare(strict_types=1);

namespace Inside\Host\Bridge;

use Exception;
use Inside\Host\Services\DrupalService;

/**
 * Bridge for inside code (bootstrap drupal)
 *
 * @category  Class
 * @package   Inside\Host\Bridge\Bridge
 * @author    Maecia <technique@maecia.com>
 * @link      http://www.maecia.com/
 */
class Bridge
{
    /**
     * Bootstrap Drupal (to use API)
     *
     * @param  bool  $fullLoad
     * @throws Exception
     */
    public function __construct(bool $fullLoad = true)
    {
        new DrupalService($fullLoad);

        // Drupal reset locales, let's refresh with our app
        app()->refreshLocales();
    }
}
