<?php

namespace Inside\Host\Actions;

use Drupal\field\Entity\FieldConfig;

class RepairFieldMaxFilesize
{
    public function repair(string $type, string $field, string $storage): string
    {
        $field_name = "field_$field";
        $storage = $storage === 'node' ? $this->guessStorageFromType($type) : $storage;
        $type = $type === 'users' ? 'user' : $type;

        /** @var \Drupal\field\Entity\FieldConfig|null $field_config */
        $field_config = FieldConfig::loadByName($storage, $type, $field_name);

        if (! $field_config) {
            return "<fg=red>✗ Champ $field_name de $type ($storage) introuvable</fg=red>";
        }

        $field_config->setSetting('max_filesize', '');
        $field_config->save();

        return "<fg=green>✔ Champ $field_name de $type ($storage) réenregistré</fg=green>";
    }

    private function guessStorageFromType(string $type): ?string
    {
        return match ($type) {
            'users' => 'user',
            'comments' => 'comment',
            default => 'node',
        };
    }
}
