<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateDeletingStrategy extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        collect(['documents', 'dms_link'])->each(
            function ($type) {
                $this->getBridge()?->contentTypeUpdate($type, ['deletion_strategy' => 'none']);
            }
        );

        $this->finishUp();
    }
}
