<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'folders',
        'translatable' => true,
        'searchable' => true,
        'permission_type' => 'content',
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => true,
        'global_searchable' => true,
        'listing_type' => 'taxo',
        'title' => [
            'fr' => 'Dossier',
            'en' => 'Folder',
            'es' => 'Carpetas',
            'de' => 'Mappe',
            'pt' => 'Ficheiro',
            'nl' => 'Map',
        ],
        'deletion_strategy' => 'only_parent',
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
                'es' => 'Imagen',
                'de' => 'Bild',
                'pt' => 'Imagem',
                'nl' => 'Afbeelding',
            ],
            'description' => [
                'fr' => 'Cette image remontera dans la page mère de l\'espace documentaire',
                'en' => 'This image goes up in the main page of the documentary space',
                'es' => 'Esta imagen sube en la página principal del espacio documental',
                'de' => 'Dieses Bild erscheint auf der Hauptseite des Dokumentarbereichs',
                'pt' => 'Esta imagem irá voltar à página principal da área de documentos',
                'nl' => 'Deze afbeelding komt naar boven op de hoofdpagina van de documentairesite',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'is_media_folder',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Dossier médiathèque',
                'en' => 'Media library folder',
                'es' => 'Carpeta de la biblioteca de medios',
                'de' => 'Ordner Medienbibliothek',
                'pt' => 'Dossier médiathèque',
                'nl' => 'Mediabibliotheekmap',
            ],
            'description' => [
                'fr' => 'Si le dossier est catégorisé comme médiathèque les fichiers à l\'intérieur se présenteront sous la forme d\'une médiathèque',
                'en' => 'If the folder is categorized as a media library the files inside will appear as a media library',
                'es' => 'Si la carpeta está categorizada como una biblioteca de medios, los archivos que contiene aparecerán como una biblioteca de medios.',
                'de' => 'If the folder is categorized as a media library the files inside will appear as a media library',
                'pt' => 'Se a pasta for categorizada como uma biblioteca de média, os ficheiros dentro dela serão apresentados como uma biblioteca de média',
                'nl' => 'Als de map is gecategoriseerd als mediabibliotheek, verschijnen de bestanden erin als mediabibliotheek',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ],
        [
            'name' => 'folders',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 2,
            'reference_is_a_parent' => true,
            'title' => [
                'fr' => 'Dossier parent',
                'en' => 'Parent folder',
                'es' => 'carpeta principal',
                'de' => 'übergeordneter Ordner',
                'pt' => 'Pasta dos pais',
                'nl' => 'Bovenliggende map',
            ],
            'description' => [
                'fr' => 'Si le dossier n\'a pas de dossier parent, il remonte sur la page principale de la GED',
                'en' => 'If the folder does not have a parent folder, it goes back to the main page of the document base',
                'es' => 'Si la carpeta no tiene una carpeta principal, vuelve a la página principal de la base del documento.',
                'de' => 'Wenn der Ordner keinen übergeordneten Ordner hat, geht er zurück auf die Hauptseite der Dokumentenbasis',
                'pt' => 'Se a pasta não tiver uma pasta principal, volta para a página principal do DMS',
                'nl' => 'Als de map geen bovenliggende map heeft, gaat deze terug naar de hoofdpagina van de documentenbasis',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['folders'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Couleur',
                'en' => 'Color',
                'es' => 'Color',
                'de' => 'Farbe',
                'pt' => 'Cor',
                'nl' => 'Kleur',
            ],
            'description' => [
                'fr' => 'Sélectionnez la couleur de votre dossier',
                'en' => 'Select your folder color',
                'es' => 'Selecciona el color de tu carpeta',
                'de' => 'Wählen Sie Ihre Ordnerfarbe',
                'pt' => 'Seleccione a cor da sua pasta',
                'nl' => 'Selecteer de kleur van uw map',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
            'default' => '#B19665',
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Ordre d\'affichage pour les dossier sans parent',
                'en' => 'Order of appearance',
                'es' => 'Orden de aparición',
                'de' => 'Reihenfolge des Erscheinens',
                'pt' => 'Ordem de exibição de pastas sem pai',
                'nl' => 'Volgorde van verschijning',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes up in 1st',
                'es' => 'El número más bajo sube en 1er.',
                'de' => 'Die niedrigste Zahl steigt in 1.',
                'pt' => 'O valor mais baixo foi em 1',
                'nl' => 'Het laagste nummer komt als eerste',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
