<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateImagesSizeForFolders extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdateField(
            type: "folders",
            fieldName: "image",
            options: [
                'name' => 'image',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Image',
                    'en' => 'Image',
                    'es' => 'Imagen',
                    'de' => 'Bild',
                    'pt' => 'Imagem',
                    'nl' => 'Afbeelding',
                ],
                'description' => [
                    'fr' => 'Cette image remontera dans la page mère de l\'espace documentaire',
                    'en' => 'This image goes up in the main page of the documentary space',
                    'es' => 'Esta imagen sube en la página principal del espacio documental',
                    'de' => 'Dieses Bild erscheint auf der Hauptseite des Dokumentarbereichs',
                    'pt' => 'Esta imagem irá voltar à página principal da área de documentos',
                    'nl' => 'Deze afbeelding komt naar boven op de hoofdpagina van de documentairesite',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::IMAGE_FIELD,
                'settings' => [
                    'min_resolution' => '366x248',
                    'max_resolution' => '732x496',
                    'uri_scheme' => 'public',
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => null,
                        'height' => null,
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'cardinality' => 1,
                ]
            ],
        );
    }
}
