<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class RenameFolderTitleForDmsLinks extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (! InsideSchema::hasModel('dms_link')) {
            return;
        }

        if (! InsideSchema::hasField('dms_link', 'folders')) {
            $this->bootUp(__FILE__);

            $this->migrateContent('dms_link');

            $this->finishUp();

            return;
        }

        $bridge = new BridgeContentType();
        $bridge->contentTypeUpdateField(
            type: 'dms_link',
            fieldName: 'folders',
            options: [
                'name' => 'folders',
                'translatable' => true,
                'title' => [
                    'fr' => 'Dossier parent',
                    'en' => 'Parent folder',
                    'es' => 'Carpeta principal',
                    'de' => 'Übergeordneter Ordner',
                    'nl' => 'Bovenliggende map',
                    'pt' => 'Pasta principal',
                ],
                'description' => [
                    'fr' => 'Dossier parent',
                    'en' => 'Parent folder',
                    'es' => 'Carpeta principal',
                    'de' => 'Übergeordneter Ordner',
                    'nl' => 'De bovenliggende map van het bestand',
                    'pt' => 'Pasta principal para o arquivo',
                ],
            ],
            weight: 3
        );
    }
}
