<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateFoldersFieldsReferenceIsAParentOption extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        collect([
            'folders',
            'documents',
            'dms_link',
        ])
            ->filter(fn ($type) => Schema::hasField($type, 'folders'))
            ->each(function ($type) {
                $this->getBridge()?->contentTypeUpdateField($type, 'folders', ['reference_is_a_parent' => true]);
                $this->getBridge()?->contentTypeUpdate($type, ['deletion_strategy' => 'only_parent']);
            });

        $this->finishUp();
    }
}
