<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Migrations\CreateContentTypes;

class CreateDmsLinkContentType extends Migration
{
    use CreateContentTypes;

    protected array $dmsContentTypes = [
        'folders',
        'documents',
        'dms_link',
    ];

    public function up(): void
    {
        $this->bootUp(__FILE__, 'dms_link');

        foreach ($this->dmsContentTypes as $type) {
            if (! Schema::hasModel($type)) {
                $this->migrateContent($type);
            }
        }

        $this->finishUp();
    }
}
