<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'name' => 'dms_link',
        'title' => [
            'fr' => 'Lien',
            'en' => 'Link',
            'es' => 'Enlace',
            'de' => 'Verknüpfung',
            'nl' => 'Link',
            'pt' => 'Link',
        ],
        'deletion_strategy' => 'only_parent',
    ],
    'fields' => [
        // Uri
        [
            'type' => BridgeContentType::TEXT_FIELD,
            'name' => 'uri',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'default' => '',
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Lien',
                'en' => 'Link',
                'es' => 'Enlace',
                'de' => 'Verknüpfung',
                'nl' => 'Link',
                'pt' => 'Link',
            ],
            'description' => [
                'fr' => '',
                'en' => '',
                'es' => '',
                'de' => '',
                'nl' => '',
                'pt' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
            ],
        ],

        // Open in a new tab
        [
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'name' => 'open_in_new_tab',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'default' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Ouverture dans un nouvel onglet',
                'en' => 'Open in a new tab',
                'es' => 'Abrir en una pestaña nueva',
                'de' => 'Öffnen Sie in einem neuen Tab',
                'nl' => 'Openen in nieuw tabblad',
                'pt' => 'Abrir em nova aba',
            ],
            'description' => [
                'fr' => '',
                'en' => '',
                'es' => '',
                'de' => '',
                'nl' => '',
                'pt' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
            ],
        ],

        // Folders
        [
            'name' => 'folders',
            'searchable' => false,
            'translatable' => false,
            'default' => [],
            'search_result_field' => false,
            'required' => true,
            'weight' => 3,
            'reference_is_a_parent' => true,
            'title' => [
                'fr' => 'Dossier parent',
                'en' => 'Parent folder',
                'es' => 'Carpeta principal',
                'de' => 'Übergeordneter Ordner',
                'nl' => 'Bovenliggende map',
                'pt' => 'Pasta principal',
            ],
            'description' => [
                'fr' => 'Dossier parent',
                'en' => 'Parent folder',
                'es' => 'Carpeta principal',
                'de' => 'Übergeordneter Ordner',
                'nl' => 'De bovenliggende map van het bestand',
                'pt' => 'Pasta principal para o arquivo',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 4,
                'group' => 'group_advanced_options',
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['folders'],
                'cardinality' => -1,
            ],
        ],

        // Image
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Image de prévisualisation',
                'en' => 'Preview image',
                'es' => 'Vista previa de la imagen',
                'de' => 'Vorschaubild',
                'nl' => 'Voorbeeldafbeelding',
                'pt' => 'Imagem de pré-visualização',
            ],
            'description' => [
                'fr' => 'Cette image sera utilisée comme image de prévisualisation dans un dossier de médiathèque',
                'en' => 'This image will be used as preview in a media folder',
                'es' => 'Esta imagen se utilizará como vista previa en una carpeta multimedia',
                'de' => 'Dieses Bild wird als Vorschau in einem Medienordner verwendet',
                'nl' => 'Deze afbeelding wordt gebruikt als voorbeeld in een mediabestand',
                'pt' => 'Esta imagem será usada como pré-visualização em uma pasta de mídia',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
    ],
];
