<?php

namespace Inside\Directory\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class AttachFetchedDirectories extends Command
{
    protected $name = 'inside:attach-fetched-directories';

    /**
     * @var string
     */
    protected $signature = 'inside:attach-fetched-directories';

    /**
     * @var string
     */
    protected $description = 'Attach fetched directories to content sections';


    /**
     * Handle index command
     *
     * @return void
     * @throws \Exception
     */
    public function handle(): void
    {
        foreach (InsideSchema::getContentTypes() as $contentType) {
            if (InsideSchema::hasField($contentType, 'content')) {
                $fieldOptions = InsideSchema::getFieldOptions($contentType, 'content');
                $tagets = $fieldOptions['target'] ?? [];
                if (in_array('fetched_directories', $tagets)) {
                    $this->line("Fetched directories already attached to content section {$contentType}");
                    continue;
                }
                $this->line("Attaching fetched directories to content section {$contentType}");
                $bridge = new BridgeContentType();
                $bridge->contentTypeUpdateField(
                    $contentType,
                    'content',
                    [
                        'type'    => BridgeContentType::SECTION_FIELD,
                        'settings' => [
                            'target_type' => array_merge($tagets, [
                                'fetched_directories',
                            ]),
                            'cardinality' => $fieldOptions['cardinality'],
                        ],
                    ]
                );
            }
        }
        Artisan::call('models:rebuild');
    }
}
