<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Facades\Schema as InsideSchema;

final class AttachFetchedDirectoriesSectionToCustomDirectories extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('custom_directories', false);
        Artisan::call('models:rebuild');
        $this->finishUp();
    }
}
