<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'name'  => 'fetched_directories',
        'title' => [
            'fr' => 'Remontée d’annuaire personnalisé',
            'en' => 'Custom directory synchronization',
            'de' => 'Benutzerdefinierte Verzeichnissynchronisierung',
            'es' => 'Sincronización de directorios personalizados',
            'nl' => 'Aangepaste directory-synchronisatie',
            'pt' => 'Sincronização de diretório personalizado',
        ],
    ],
    'fields'  => [
        [
            'name' => 'fetched_title',
            'searchable' => false,
            'translatable' => true,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Titre',
                'en' => 'Title',
                'de' => 'Titel',
                'es' => 'Título',
                'pt' => 'Título',
                'it' => 'Titolo',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'directory_selection',
            'searchable' => false,
            'translatable' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Sélection de l’annuaire',
                'en' => 'Directory selection',
                'de' => 'Verzeichnisauswahl',
                'es' => 'Selección de directorio',
                'pt' => 'Seleção de diretório',
                'it' => 'Selezione directory',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content_selection',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Sélection du contenu',
                'en' => 'Content selection',
                'de' => 'Inhaltsauswahl',
                'es' => 'Selección de contenido',
                'pt' => 'Seleção de conteúdo',
                'it' => 'Selezione del contenuto',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'limit',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Limite',
                'en' => 'Limit',
                'de' => 'Limit',
                'es' => 'Límite',
                'pt' => 'Limite',
                'it' => 'Limite',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => ['cardinality' => 1],
        ],
        [
            'name' => 'sort',
            'searchable' => false,
            'translatable' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Ordre',
                'en' => 'Sort',
                'de' => 'Sortierung',
                'es' => 'Orden',
                'pt' => 'Ordenação',
                'it' => 'Ordinamento',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => ['size' => 60],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => ['max_length' => 255, 'cardinality' => 1],
        ],
        [
            'name' => 'show_pagination',
            'searchable' => false,
            'default' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Afficher la pagination',
                'en' => 'Show pagination',
                'de' => 'Pagination anzeigen',
                'es' => 'Mostrar paginación',
                'pt' => 'Exibir paginação',
                'it' => 'Mostra paginazione',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => ['display_label' => true],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => ['cardinality' => 1],
        ],
        [
            'name' => 'one_column_display',
            'searchable' => false,
            'default' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Afficher dans une colonne',
                'en' => 'Show in one column',
                'de' => 'In einer Spalte anzeigen',
                'es' => 'Mostrar en una columna',
                'pt' => 'Exibir em uma coluna',
                'it' => 'Mostra in una colonna',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => ['display_label' => true],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => ['cardinality' => 1],
        ],
        [
            'name' => 'custom_order',
            'searchable' => false,
            'default' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Ordre personnalisé',
                'en' => 'Custom order',
                'de' => 'Benutzerdefinierte Reihenfolge',
                'es' => 'Orden personalizado',
                'pt' => 'Ordem personalizada',
                'it' => 'Ordine personalizzato',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => ['display_label' => true],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => ['cardinality' => 1],
        ],
        [
            'name' => 'link_label',
            'searchable' => false,
            'translatable' => true,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Label du lien',
                'en' => 'Link label',
                'de' => 'Link-Bezeichnung',
                'es' => 'Etiqueta del enlace',
                'pt' => 'Etiqueta do link',
                'it' => 'Etichetta del collegamento',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => ['size' => 60],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => ['max_length' => 255, 'cardinality' => 1],
        ],
        [
            'name' => 'fetch_link',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Lien',
                'en' => 'Link',
                'de' => 'Link',
                'es' => 'Enlace',
                'pt' => 'Link',
                'it' => 'Collegamento',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => ['max_length' => 255, 'cardinality' => 1],
        ],
    ],
];
