<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Migrations\CreateContentTypes;

final class AddFetchedDirectoriesSection extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('fetched_directories', false, 'sections');
        Artisan::call('models:rebuild');
        $this->finishUp();

        $command = collect(['php', '-d memory_limit=-1', cms_base_path('vendor/bin/drush'), 'config:export', '--yes'])->join(' ');
        exec(windows_os() ? str_replace('/', '\\', $command) : $command);

        Artisan::call('inside:paragraph:bundles:translatable');
        Artisan::call('inside:paragraph:config:generate');
        Artisan::call('inside:paragraph:config:import');
    }
}
