<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => true,
        'searchable'        => true,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => true,
        'name'              => 'custom_directories',
        'listing_type'      => 'content',
        'title'             => [
            'fr' => 'Annuaire Personnalisé',
            'en' => 'Custom Directory',
            'nl' => 'Aangepaste map',
            'de' => 'Benutzerdefinierter Ordner',
            'es' => 'Directorio personalizado',
            'pt' => 'Diretório personalizado',
        ],
    ],
    'fields'  => [
        // Description et image
        [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'directory_description',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'default'             => '',
            'title'               => [
                'fr' => 'Description',
                'en' => 'Description',
                'nl' => 'Beschrijving',
                'de' => 'Beschreibung',
                'es' => 'Descripción',
                'pt' => 'Descrição',
            ],
            'description'         => [
                'fr' => 'Description de l\'annuaire',
                'en' => 'Directory description',
                'es' => 'Descripción del directorio',
                'nl' => 'Beschrijving van de map',
                'de' => 'Beschreibung des Ordners',
                'pt' => 'Descrição do diretório',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
            ],
        ],
        [
            'type'                => BridgeContentType::IMAGE_FIELD,
            'name'                => 'image',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Bannière',
                'en' => 'Banner',
                'es' => 'Banner',
                'pt' => 'Banner',
                'de' => 'Banner',
                'nl' => 'Banner',
            ],
            'description'         => [
                'fr' => 'Cette image s’affiche sur toute la largeur',
                'en' => 'This image is displayed on the whole width',
                'es' => 'Esta imagen se muestra en toda la anchura',
                'pt' => 'Esta imagem é exibida em toda a largura',
                'de' => 'Dieses Bild wird auf der gesamten Breite angezeigt',
                'nl' => 'Deze afbeelding wordt over de hele breedte weergegeven',
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'mimetypes'       => 'image/png,image/gif,image/jpeg',
                    'file_extensions' => 'png,gif,jpg,jpeg',
                    'max_filesize'    => 536870912,
                    'max_width'       => 300,
                    'max_height'      => 300,
                    'min_width'       => 250,
                    'min_height'      => 250,
                ],
            ],
        ],
        [
            'type'                => BridgeContentType::IMAGE_FIELD,
            'name'                => 'preview_image',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 2,
            'title' => [
                'fr' => 'Image d\'aperçu',
                'en' => 'Preview image',
                'es' => 'Imagen de vista previa',
                'pt' => 'Imagem de pré-visualização',
                'de' => 'Vorschaubild',
                'nl' => 'Voorbeeldafbeelding',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 2,
            ],
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'color',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Couleur',
                'en' => 'Color',
                'es' => 'Color',
                'de' => 'Farbe',
                'nl' => 'Kleur',
                'pt' => 'Cor',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],

        // Affichage
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'search_bar_enabled',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 3,
            'default'             => false,
            'title'               => [
                'fr' => 'Activer la barre de recherche',
                'en' => 'Enable search bar',
                'es' => 'Activar barra de búsqueda',
                'de' => 'Suche aktivieren',
                'nl' => 'Zoeken inschakelen',
                'pt' => 'Ativar barra de pesquisa',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => 3,
                'group' => '',
            ],
        ],
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'default_display_mode',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 4,
            'default'             => '',
            'title'               => [
                'fr' => 'Affichage par défaut',
                'en' => 'Default display mode',
                'es' => 'Modo de visualización predeterminado',
                'de' => 'Standardanzeigemodus',
                'nl' => 'Standaardweergavemodus',
                'pt' => 'Modo de visualização padrão',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => 4,
                'group' => '',
            ],
        ],

        // Types de contenu référence
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'referenced_content_types',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 5,
            'title'               => [
                'fr' => 'Types de contenu référence',
                'en' => 'Content types reference',
                'es' => 'Tipos de contenido de referencia',
                'de' => 'Inhaltstypenverweis',
                'nl' => 'Inhoudstype verwijzing',
                'pt' => 'Tipos de contenido de referencia'
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
        ],

        // Ayant pour
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'request_filters',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 5,
            'title'               => [
                'fr' => 'Filtres demandés',
                'en' => 'Requested filters',
                'es' => 'Filtros solicitados',
                'de' => 'Angeforderte Filter',
                'nl' => 'Aangevraagde filters',
                'pt' => 'Filtros solicitados',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
        ],

        // Configurer les filtres
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'directory_filters',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 5,
            'title'               => [
                'fr' => 'Filtre de l\'annuaire',
                'en' => 'Directory filter',
                'es' => 'Filtro del directorio',
                'de' => 'Verzeichnisfilter',
                'nl' => 'Mapfilter',
                'pt' => 'Filtro do diretório',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
        ],

        //Configurer la vue tableau
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'directory_columns',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 5,
            'title'               => [
                'fr' => 'Colonnes de l\'annuaire',
                'en' => 'Directory columns',
                'es' => 'Columnas del directorio',
                'de' => 'Verzeichnisspalten',
                'nl' => 'Mapkolommen',
                'pt' => 'Colunas do diretório',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
        ],

        // Configurer la vue card
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'enable_image_in_card',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 6,
            'default'             => true,
            'title'               => [
                'fr' => 'Les utilisateurs ne peuvent répondre qu’une seule fois',
                'en' => 'Users can only answer once',
                'es' => 'Los usuarios solo pueden responder una vez',
                'pt' => 'Os usuários só podem responder uma vez',
                'de' => 'Benutzer können nur einmal antworten',
                'nl' => 'Gebruikers kunnen maar één keer antwoorden',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => 6,
                'group' => 'general_settings',
            ],
        ],
        [
            'type'                => BridgeContentType::TEXT_FIELD,
            'name'                => 'image_key_in_card',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 4,
            'default'             => '',
            'title'               => [
                'fr' => 'Choix champ image',
                'en' => 'Image key choice',
                'de' => 'Bildauswahl',
                'nl' => 'Kies afbeeldings sleutel',
                'es' => 'Elección del campo de imagen',
                'pt' => 'Escolha do campo de imagem',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [],
                'weight' => 4,
                'group' => '',
            ],
        ],
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'directory_card_content',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 4,
            'default'             => '',
            'title'               => [
                'fr' => 'Choix autre champs',
                'en' => 'Other field choice',
                'de' => 'Andere Feld Auswahl',
                'nl' => 'Kies andere velden',
                'es' => 'Elección de otros campos',
                'pt' => 'Escolha de outros campos',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => 4,
                'group' => '',
            ],
        ],

        // Configurer la vue modale
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'enable_image_in_modal',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 7,
            'default'             => true,
            'title'               => [
                'fr' => 'Les demandes des utilisateurs doivent être validées par les administrateurs',
                'en' => 'User requests must be validated by administrators',
                'es' => 'Las solicitudes de los usuarios deben ser validadas por los administradores',
                'pt' => 'As solicitações dos usuários devem ser validadas pelos administradores',
                'de' => 'Benutzeranfragen müssen von Administratoren validiert werden',
                'nl' => 'Gebruikersverzoeken moeten worden gevalideerd door beheerders',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => 7,
                'group' => 'general_settings',
            ],
        ],
        [
            'type'                => BridgeContentType::TEXT_FIELD,
            'name'                => 'image_key_in_modal',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 4,
            'default'             => '',
            'title'               => [
                'fr' => 'Choix champ image',
                'en' => 'Image key choice',
                'de' => 'Bildauswahl',
                'nl' => 'Kies afbeeldings sleutel',
                'es' => 'Elección del campo de imagen',
                'pt' => 'Escolha do campo de imagem',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::STRING_WIDGET,
                'settings' => [],
                'weight' => 4,
                'group' => '',
            ],
        ],
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'directory_modal_content',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 4,
            'default'             => '',
            'title'               => [
                'fr' => 'Choix autre champs',
                'en' => 'Other field choice',
                'de' => 'Andere Feld Auswahl',
                'nl' => 'Kies andere velden',
                'es' => 'Elección de otros campos',
                'pt' => 'Escolha de outros campos',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => 4,
                'group' => '',
            ],
        ],
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 10,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'es' => 'Contenido',
                'pt' => 'Conteúdo',
                'de' => 'Inhalt',
                'nl' => 'Inhoud',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 10,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'fetched_directories',
                ],
                'cardinality' => -1,
            ],
        ],
    ],
];
