<?php

use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\BooleanField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\EntityReferenceField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\EntityReferenceRevisionsField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\FileField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\ImageField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\IntegerField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\StringField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\StringListField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\StringLongField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\TextLongField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\TextWithSummaryField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\TimestampField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Field\VideoField;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage\BaseStorage;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Field\Storage\BooleanStorage;
use Inside\Content\Services\ConfigurationGenerator\Bundle\Paragraphs\ParagraphsTypeBundle;

return [
    /*
    |--------------------------------------------------------------------------
    | Paragraphs custom
    |--------------------------------------------------------------------------
    |
    | You can override in the back repository this configuration to add
    | your own cutsomized paragraphs.
    |
    */
    'custom' => [
        'fetched_directories' => [
            'label' => 'field.fetched_directories.label',
            'fields' => [
                'field_fetched_title' => [
                    'class' => StringField::class,
                    'label' => 'field.title.label',
                ],
                'field_directory_selection' => [
                    'class' => StringField::class,
                    'label' => 'field.directory_selection.label',
                    'required' => true,
                ],
                'field_content_selection' => [
                    'class' => StringField::class,
                    'label' => 'field.content_selection.label',
                ],
                'field_limit' => [
                    'class' => IntegerField::class,
                    'label' => 'field.limit.label',
                ],
                'field_sort' => [
                    'class' => StringField::class,
                    'label' => 'field.order.label',
                ],
                'field_show_pagination' => [
                    'class' => BooleanField::class,
                    'label' => 'field.show_pagination.label',
                ],
                'field_one_column_display' => [
                    'class' => BooleanField::class,
                    'label' => 'field.one_column_display.label',
                ],
                'field_custom_order' => [
                    'class' => BooleanField::class,
                    'label' => 'field.custom_order.label',
                ],
                'field_link_label' => [
                    'class' => StringField::class,
                    'label' => 'field.link_label.label',
                ],
                'field_fetch_link' => [
                    'class' => StringField::class,
                    'label' => 'field.link.label',
                ],
            ],
        ],
    ],
];
