<?php

declare(strict_types=1);

use Illuminate\Support\Facades\Route;
use Inside\Routing\Router;

Route::group(
    [
        'namespace' => 'Inside\Course\Http\Controllers',
        'prefix' => 'api/v1/courses',
        'middleware' => 'auth.api',
    ],
    function (Router $router) {
        // Courses
        $router->post('/{uuid}/publish', ['uses' => 'CoursesController@publish']);
        $router->post('/{uuid}/unpublish', ['uses' => 'CoursesController@unpublish']);
        $router->post('/{uuid}/visit', ['uses' => 'CoursesController@visit']);

        // Progression
        $router->get('/progression/{uuid}', ['uses' => 'CourseProgressionController@getProgression']);
        $router->post('/progression/step/{uuid}/validate', ['uses' => 'CourseProgressionController@validateStep']);
        $router->post('/progression/step/{uuid}/invalidate', ['uses' => 'CourseProgressionController@invalidateStep']);

        // Categories
        $router->get('/categories/{uuid}/is_subscribed', ['uses' => 'CoursesCategoriesController@isSubscribed']);
        $router->post('/categories/{uuid}/subscribe', ['uses' => 'CoursesCategoriesController@subscribe']);
        $router->post('/categories/{uuid}/unsubscribe', ['uses' => 'CoursesCategoriesController@unsubscribe']);
    }
);

Route::group(
    [
        'namespace' => 'Inside\Course\Http\Controllers',
        'prefix' => 'api/v1/courses/stats',
        'middleware' => ['auth.backoffice.access:statistic'],
    ],
    function (Router $router) {
        // Course statistics
        $router->get('/courses', ['uses' => 'CoursesStatisticsController@index']);
        $router->get('/courses/export', ['uses' => 'CoursesStatisticsController@exportIndex']);

        $router->get('/courses/{uuid}', ['uses' => 'CoursesStatisticsController@detail']);
        $router->get('/courses/{uuid}/export', ['uses' => 'CoursesStatisticsController@exportDetail']);

        // Course Users statistics
        $router->get('/users', ['uses' => 'CourseUsersStatisticsController@index']);
        $router->get('/users/export', ['uses' => 'CourseUsersStatisticsController@exportIndex']);

        $router->get('/users/{uuid}', ['uses' => 'CourseUsersStatisticsController@detail']);
        $router->get('/users/{uuid}/export', ['uses' => 'CourseUsersStatisticsController@exportDetail']);
    }
);
