<?php

declare(strict_types=1);

namespace Inside\Course\Observers;

use Inside\Course\Contracts\CourseProgression;
use Inside\Course\Models\StepValidation;

final class StepValidationObserver
{
    public function __construct(
        private CourseProgression $courseProgression
    ) {
    }

    public function saved(StepValidation $stepValidation): void
    {
        $this->courseProgression->computeUserProgression($stepValidation->step->chapter->course, $stepValidation->user);
    }

    public function deleted(StepValidation $stepValidation): void
    {
        $this->courseProgression->computeUserProgression($stepValidation->step->chapter->course, $stepValidation->user);
    }
}
