<?php

declare(strict_types=1);

namespace Inside\Course\Observers;

use Inside\Course\Contracts\CourseProgression;
use Inside\Course\Models\Course;

final class CourseObserver
{
    public function __construct(
        private CourseProgression $courseProgression
    ) {
    }

    public function updated(Course $course): void
    {
        if ($course->isDirty('total_steps')) {
            $this->courseProgression->computeAllProgressions($course);
        }
    }
}
