<?php

declare(strict_types=1);

namespace Inside\Course\Observers;

use Inside\Course\Contracts\CourseProgression;
use Inside\Course\Models\Chapter;

final class ChapterObserver
{
    public function __construct(
        private CourseProgression $courseProgression
    ) {
    }

    public function saved(Chapter $chapter): void
    {
        $this->courseProgression->updateCourseTotalSteps($chapter->course);
    }

    public function deleted(Chapter $chapter): void
    {
        $this->courseProgression->updateCourseTotalSteps($chapter->course);
    }
}
