<?php

declare(strict_types=1);

namespace Inside\Course\Models;

use Closure;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Collection;
use Inside\Database\Eloquent\Builder;
use Inside\Database\Eloquent\WithEnhancedBuilder;
use Inside\User\Models\User;

/**
 * @property int $created_at
 * @property int $updated_at
 * @property bool $validated
 * @property User $user
 * @property Step $step
 *
 * @method static static updateOrCreate(array $attributes, array $values = [])
 * @method static Collection pluck($column, $key = null)
 * @method static Builder query()
 * @method static Builder ofCourse(Course $course)
 */
class StepValidation extends Model
{
    use WithEnhancedBuilder;

    /**
     * @var string
     */
    protected $table = 'inside_courses_steps_users_validations';

    /**
     * @var string[]
     */
    protected $fillable = [
        'validated',
        'user_uuid',
        'step_id',
    ];

    /**
     * @var array
     */
    protected $casts = [
        'created_at' => 'timestamp',
        'updated_at' => 'timestamp',
        'validated' => 'boolean',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function step(): BelongsTo
    {
        return $this->belongsTo(Step::class);
    }

    public function scopeOfCourse(Builder $query, Course $course): Builder
    {
        return $query->whereHas(
            'step.chapter.course',
            fn (Builder $query) => $query->where('id', $course->id)
        );
    }
}
