<?php

declare(strict_types=1);

namespace Inside\Course\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Authentication\Models\User;
use Inside\Database\Eloquent\Builder;
use Inside\Database\Eloquent\WithEnhancedBuilder;

/**
 * @property int $id
 * @property int $course_id
 * @property string $user_uuid
 * @property bool $viewed
 * @property bool $started
 * @property bool $finished
 * @property float $ratio
 * @property Course $course
 * @property User $user
 *
 * @method static static create(array $attributes = [])
 * @method static static firstOrFail(array $attributes = [])
 * @method static static updateOrCreate(array $attributes, array $values = [])
 * @method static static|null firstWhere($column, $operator = null, $value = null, $boolean = 'and')
 * @method static Builder query()
 * @method static Builder where($column, $operator = null, $value = null, $boolean = 'and')
 * @method static Builder|static ofCourse(Course $course)
 *
 * @mixin Collection
 */
class CourseUsersStatistics extends Model
{
    use WithEnhancedBuilder;

    /**
     * @var string
     */
    protected $table = 'inside_courses_users_statistics';

    /**
     * @var bool
     */
    public $timestamps = false;

    /**
     * @var string[]
     */
    protected $fillable = [
        'course_id',
        'user_uuid',
        'viewed',
        'started',
        'finished',
        'ratio',
    ];


    public function course(): BelongsTo
    {
        return $this->belongsTo(Course::class);
    }

    public function scopeOfCourse(Builder $query, Course $course): Builder
    {
        return $query->where('course_id', $course->id);
    }
}
