<?php

namespace Inside\Course\Http\Middlewares;

use Closure;
use Illuminate\Http\Request;
use Inside\Permission\Facades\Permission;
use Symfony\Component\HttpFoundation\Response;

/**
 * Handle automatic translation
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class HideUnpublishedCoursesFromSearch
{
    public function handle(Request $request, Closure $next): mixed
    {
        return match (true) {
            $request->is('api/v1/search') && $request->isMethod('GET') => $this->filterCourses($request, $next),
            default => $next($request),
        };
    }

    private function filterCourses(Request $request, Closure $next): mixed
    {
        $response = $next($request);

        if (Permission::allowed('update', 'courses')) {
            return $response;
        }

        $result = json_decode($response->getContent(), true);

        /** @var array<string> $unpublishedCourses */
        $unpublishedCourses = type_to_class('courses')::query()->where('published', false)->orWhereNull('published')->pluck('uuid')->toArray();

        $data = collect($result['data'] ?? [])
            ->reject(fn (array $course) => in_array($course['uuid'], $unpublishedCourses))
            ->values()
            ->all();

        $result['data'] = $data;

        return $response->setData($result);
    }
}
