<?php

declare(strict_types=1);

namespace Inside\Course\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Course\Contracts\CourseProgression;
use Inside\Course\Models\Course;
use Inside\Course\Models\Step;

final class CourseProgressionController extends Controller
{
    public function getProgression(string $uuid, CourseProgression $courseProgression): JsonResponse
    {
        /** @var User $user */
        $user = Auth::user();

        /** @var Course $course */
        $course = Course::where('model_uuid', $uuid)->firstOrFail();

        $userProgression = $courseProgression->getUserCourseProgression($user, $course);

        return response()->json($userProgression);
    }

    public function validateStep(string $uuid): JsonResponse
    {
        /** @var User $user */
        $user = Auth::user();

        /** @var Step $step */
        $step = Step::where('model_uuid', $uuid)->firstOrFail();

        $validation = $step->validate($user);

        return response()
            ->json(
                data: [
                    'validated' => $validation->validated,
                    'validated_at' => $validation->updated_at,
                ],
                status: 201
            );
    }

    public function invalidateStep(string $uuid): JsonResponse
    {
        /** @var User $user */
        $user = Auth::user();

        /** @var Step $step */
        $step = Step::where('model_uuid', $uuid)->firstOrFail();

        $step->invalidate($user);

        return response()
            ->json(
                data: ['validated' => false],
                status: 201
            );
    }
}
