<?php

declare(strict_types=1);

namespace Inside\Course\Exports;

use Illuminate\Support\Facades\Lang;
use Inside\Course\Contracts\CourseUsersStatistics;

final class CourseUserDetailStatisticsExport extends AbstractCourseStatisticsExport
{
    private ?CourseUsersStatistics $courseUsersStatistics = null;

    private function getCourseUsersStatistics(): CourseUsersStatistics
    {
        return $this->courseUsersStatistics ??= app(CourseUsersStatistics::class);
    }

    public function __construct(
        private string $userUuid,
        private ?string $search = null,
        private array $filters = [],
        private ?string $langcode = 'en'
    ) {
    }

    public function query()
    {
        return $this->getCourseUsersStatistics()->getCourseUsersDetailStatisticsQuery($this->userUuid, $this->search, $this->filters);
    }

    public function headings(): array
    {
        if ($this->langcode) {
            Lang::setLocale($this->langcode);
        }

        return [
            Lang::get('courses.statistics.export.user.detail.cols.title'),
            Lang::get('courses.statistics.export.user.detail.cols.viewed'),
            Lang::get('courses.statistics.export.user.detail.cols.finished'),
            Lang::get('courses.statistics.export.user.detail.cols.started'),
            Lang::get('courses.statistics.export.user.detail.cols.ratio'),
        ];
    }

    public function map($row): array
    {
        return [
            $row->title,
            $this->mapBooleanValue($row->viewed),
            $this->mapBooleanValue($row->started),
            $this->mapBooleanValue($row->finished),
            $row->ratio * 100 .'%',
        ];
    }
}
