<?php

declare(strict_types=1);

namespace Inside\Course\Contracts;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Contracts\Pagination\Paginator;
use Illuminate\Support\Collection;
use Inside\Database\Eloquent\Builder;

interface CourseUsersStatistics
{
    public function getCourseUsersStatistics(?string $search = null, array $filters = []): Paginator | Collection | LengthAwarePaginator | array;

    public function getCourseUsersStatisticsQuery(?string $search = null, array $filters = []): Builder;

    public function getCourseUsersDetailStatisticsQuery(string $userUuid, ?string $search = null, array $filters = []): Builder;

    public function getCourseUsersDetailStatistics(string $userUuid, ?string $search = null, array $filters = []): Paginator | Collection | LengthAwarePaginator | array;
}
