<?php

declare(strict_types=1);

namespace Inside\Course\Contracts;

use Inside\Authentication\Models\User;
use Inside\Course\Models\Course;
use Inside\Course\Models\CourseStatistics;
use Inside\Course\Models\CourseUsersStatistics;

interface CourseStatisticsComputer
{
    public function computeCompleteCourseStatistics(Course $course): void;

    public function computeCourseStatistics(Course $course): CourseStatistics;

    public function computeCourseUsersStatistics(Course $course, User $user): CourseUsersStatistics;
}
