<?php

declare(strict_types=1);

namespace Inside\Course\Console;

use Illuminate\Database\Eloquent\Builder;
use Inside\Console\Command;
use Inside\Course\Contracts\CourseProgression;
use Inside\Course\Models\Course;
use Inside\Course\Models\UserProgression;

final class RecomputeCoursesProgressionCommand extends Command
{
    /**
     * @var string
     */
    protected $signature = 'inside:courses:progression:compute {--c|courses= : uuids of courses delimited by comma}';

    /**
     * @var string
     */
    protected $description = 'Compute users progression for all courses';

    public function handle(CourseProgression $courseProgression): void
    {
        $coursesUuids = str($this->option('courses') ?? '')->explode(',')->filter();

        $courses = Course::query()
            ->when($coursesUuids->isNotEmpty(), fn (Builder $query) => $query->whereIn('model_uuid', $coursesUuids))
            ->get();

        $this->getOutput()->text("Calculate users progression on courses ({$courses->count()})");

        UserProgression::whereIn('course_id', $courses->pluck('id'))->delete();

        $this->getOutput()->progressStart($courses->count());
        $courses->each(function (Course $course) use ($courseProgression) {
            $courseProgression->computeAllProgressions($course);
            $this->getOutput()->progressAdvance();
        });
        $this->getOutput()->progressFinish();
    }
}
