<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'course_question',
        'title' => [
            'fr' => 'Question',
            'en' => 'Question',
            'es' => 'Pregunta',
            'de' => 'Frage',
            'pt' => 'Pergunta',
            'nl' => 'Vraag',
        ],
    ],
    'fields' => [
        [
            'name' => 'question_title',
            'translatable' => true,
            'default' => '',
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Titre de votre question',
                'en' => 'Title of your question',
                'es' => 'Título de tu pregunta',
                'de' => 'Titel Ihrer Frage',
                'pt' => 'Título da sua pergunta',
                'nl' => 'Titel van uw vraag',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::TEXT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'question_details',
            'required' => false,
            'translatable' => true,
            'weight' => 1,
            'default' => '',
            'title' => [
                'fr' => 'Complément d\'information sur votre question',
                'en' => 'Details about your question',
                'es' => 'Detalles sobre tu pregunta',
                'de' => 'Details zu Ihrer Frage',
                'pt' => 'Detalhes sobre sua pergunta',
                'nl' => 'Details over uw vraag',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [],
        ],
        [
            'name' => 'question_image',
            'required' => false,
            'translatable' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Image d\'illustration de votre question',
                'en' => 'Image of your question',
                'es' => 'Imagen de tu pregunta',
                'de' => 'Bild Ihrer Frage',
                'pt' => 'Imagem da sua pergunta',
                'nl' => 'Afbeelding van uw vraag',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'mimetypes' => 'image/png,image/gif,image/jpeg',
                    'file_extensions' => 'png,gif,jpg,jpeg',
                ],
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
        ],
        [
            'name' => 'content',
            'translatable' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Réponses',
                'en' => 'Answers',
                'es' => 'Respuestas',
                'de' => 'Antworten',
                'pt' => 'Respostas',
                'nl' => 'Antwoorden',
            ],
            'settings' => [
                'target_type' => [
                    'course_answer',
                ],
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::SECTION_FIELD,
        ],
    ],
];
