<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'course_answer',
        'title' => [
            'fr' => 'Réponse',
            'en' => 'Answer',
            'es' => 'Respuesta',
            'de' => 'Antwort',
            'pt' => 'Resposta',
            'nl' => 'Antwoord',
        ],
    ],
    'fields' => [
        [
            'name' => 'answer_title',
            'default' => '',
            'translatable' => true,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Réponse',
                'en' => 'Answer',
                'es' => 'Respuesta',
                'de' => 'Antwort',
                'pt' => 'Resposta',
                'nl' => 'Antwoord',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::TEXT_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'answer_correct',
            'required' => false,
            'weight' => 1,
            'default' => false,
            'title' => [
                'fr' => 'Réponse correcte',
                'en' => 'Correct answer',
                'es' => 'Respuesta correcta',
                'de' => 'Richtige Antwort',
                'pt' => 'Resposta correta',
                'nl' => 'Correct antwoord',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [],
        ],
    ],
];
