<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class CreateDefaultReminderEmailSettings extends Migration
{
    public function up(): void
    {
        $settings = [
            'onboarding_email_subject_fr' => 'Bienvenue ! Il est temps de commencer votre première formation',
            'onboarding_email_text_fr' => 'Bienvenue ! Il est temps de commencer votre première formation',
            'onboarding_email_button_text_fr' => 'Commencer ma formation',
            'onboarding_email_enabled' => 1,
            'reminder_email_enabled' => 1,
            'onboarding_course' => optional(type_to_class('courses')::query()->first())->uuid ?? '',
            'reminder_email_subject_fr' => 'Vous avez une ou plusieurs formation(s) à suivre !',
            'reminder_email_not_started_title_fr' => 'Vous avez une ou plusieurs formation(s) obligatoires(s) !',
            'reminder_email_in_progress_title_fr' => 'Vous avez une ou plusieurs formation(s) a terminer !',
            'reminder_email_in_progress_button_title_fr' => 'Poursuivre cette formation',
            'reminder_email_not_started_button_title_fr' => 'Débuter cette formation',
            'reminder_email_recurrence_type' => 'weekly',
            'reminder_email_day' => 7,
            'reminder_email_hour' => '21:00',
        ];

        collect($settings)->each(
            fn ($value, $key) =>
            Setting::firstOrCreate(['group' => 'courses', 'key' => $key], ['value' => $value])
        );
    }
}
