<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class CreateNotificationTypesForCourses extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'default'   => true,
                'event'     => 'Inside\Authentication\Events\FirstConnection',
                'model'     => 'Inside\Content\Models\Contents\Courses',
                'action'    => 'onboarding',
                'type'      => 'global',
                'condition' => null,
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.courses.onboarding.mail.title',
                    'description' => 'notifications.courses.onboarding.mail.description',
                    'text' => 'notifications.courses.onboarding.mail.text',
                    'view' => 'onboardingEmail',
                    'mail' => [
                        'subject' => 'notifications.courses.onboarding.mail.subject',
                        'text' => 'notifications.courses.onboarding.mail.text',
                        'buttonText' => 'notifications.courses.onboarding.mail.buttonText',
                    ],
                    'fields' => [
                        'title',
                        'image',
                        'duration',
                        'content_type',
                    ],
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via'       => 'email',
                'default'   => true,
                'event'     => null,
                'model'     => 'Inside\Content\Models\Contents\Courses',
                'action'    => 'reminder',
                'type'      => 'global',
                'condition' => null,
                'multiple'  => false,
                'language'  => false,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.courses.reminder.mail.title',
                    'description' => 'notifications.courses.reminder.mail.description',
                    'text' => 'notifications.courses.reminder.mail.text',
                    'view' => 'reminderEmail',
                    'mail' => [
                        'subject' => 'notifications.courses.reminder.mail.subject',
                        'text' => 'notifications.courses.reminder.mail.text',
                        'buttonText' => 'notifications.courses.reminder.mail.buttonText',
                    ],
                    'fields' => [],
                ],
            ]
        );
    }
}
