<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateCardinalitiesForCoursesCategoriesField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField(
            type: 'courses',
            fieldName: 'courses_categories',
            options: [
                'name' => 'courses_categories',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => true,
                'weight' => 2,
                'title' => [
                    'fr' => 'Catégorie de formation',
                    'en' => 'Training category',
                    'es' => 'Categoría de formación',
                    'de' => 'Trainingskategorie',
                    'pt' => 'Categoria de formação',
                    'nl' => 'Training categorie',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['courses_categories'],
                    'cardinality' => -1,
                ],
            ],
            weight: 2
        );
        $bridge->switchCardinalityFromUnaryToMultiple('courses', 'courses_categories');
    }
}
