<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Host\Migrations\CreateContentTypes;

class CreateCoursesStepsTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('inside_courses_steps')) {
            return;
        }

        Schema::create('inside_courses_steps', function (Blueprint $table) {
            $table->increments('id');
            $table->uuid('model_uuid');
            $table->string('model_type');
            $table->string('title');
            $table->unsignedInteger('chapter_id');
            $table->integer('weight')->nullable();
            $table->char('langcode', 2);
            $table->boolean('status');
            $table->timestamps();

            $table->index('model_uuid');
            $table->index('langcode');

            $table->foreign('chapter_id')
                ->references('id')
                ->on('inside_courses_chapters')
                ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_courses_steps');
    }
}
