<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Host\Migrations\CreateContentTypes;

class CreateCoursesChaptersTable extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('inside_courses_chapters')) {
            return;
        }

        Schema::create('inside_courses_chapters', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->uuid('model_uuid');
            $table->unsignedInteger('course_id');
            $table->char('langcode', 2);
            $table->integer('weight')->nullable();
            $table->boolean('status');
            $table->timestamps();

            $table->index('model_uuid');
            $table->index('langcode');

            $table->foreign('model_uuid')
                ->references('uuid')
                ->on(type_to_table('courses_chapters'))
                ->onDelete('cascade');

            $table->foreign('course_id')
                ->references('id')
                ->on('inside_courses')
                ->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('inside_courses_chapters');
    }
}
